CREATE OR REPLACE PACKAGE bank_context2_pkg IS

  -- Funkcia vrati, pre dany login klienta sol.
  FUNCTION get_client_salt(p_login IN client.login%TYPE) RETURN client.salt%TYPE;

  --Funkcia vrati, pre dany login zamestnanca sol.
  FUNCTION get_employee_salt(p_login IN employee.login%TYPE) RETURN employee.salt%TYPE;

  -- Procedura nastavi kontext zakaznikovi - nastavi jeho id
  PROCEDURE init_client_context(p_login    IN client.login%TYPE,
                                p_password IN client.password%TYPE);

  -- Procedure pre klienta - nastavi ucet do kontextu
  PROCEDURE set_client_account_no(p_account_no IN account.account_no%TYPE);

  -- Procedura nastavi kontext zamestnancovi
  PROCEDURE init_employee_context(p_login    IN employee.login%TYPE,
                                  p_password IN employee.password%TYPE);

  -- Procedura pre zamestnanca - nastavi id klienta
  PROCEDURE set_employee_client_id(p_client_id IN client.client_id%TYPE);

  -- Procedura pre zamestnanca - nastavi ucet klienta
  PROCEDURE set_employye_account_no(p_account_no IN account.account_no%TYPE);

  -- Procedura nastavi kontext terminalu
  PROCEDURE init_terminal_context(p_card_no IN card.card_no%TYPE,
                                  p_pin     IN card.pin%TYPE);

END bank_context2_pkg;
/

